/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import panther.util.resource.ResourceLogConfig;
import panther.util.resource.ResourcePool;
import panther.util.unicon.GuaranteedAction;

public class ResourceLog {
    public static final Logger LOGGER = Logger.getLogger(ResourceLog.class.getName());
    private ResourceLogConfig logConfig;

    public ResourceLog(ResourceLogConfig resourceLogConfig) {
        this.logConfig = resourceLogConfig;
    }

    public void error(ResourcePool resourcePool, Throwable throwable) {
        this.myLog(0, resourcePool, -1L, "error", "ALERT", throwable, -1L);
    }

    public void error(ResourcePool resourcePool, Object object, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        this.myLog(0, resourcePool, -1L, "error", "ALERT", object + " --> " + throwable + "\n" + stringWriter, -1L);
    }

    public void log(int n, String string) {
        this.myLog(n, string);
    }

    public void log(int n, ResourcePool resourcePool, Object object) {
        this.myLog(n, resourcePool, -1L, null, null, object, -1L);
    }

    public void log(int n, ResourcePool resourcePool, String string, String string2) {
        this.myLog(n, resourcePool, -1L, string, string2, null, -1L);
    }

    public void log(int n, ResourcePool resourcePool, String string, String string2, Object object) {
        this.myLog(n, resourcePool, -1L, string, string2, object, -1L);
    }

    public long time(int n, ResourcePool resourcePool, long l, String string, String string2) {
        return this.myLog(n, resourcePool, l, string, string2, null, -1L);
    }

    public long time(int n, ResourcePool resourcePool, long l, String string, String string2, Object object) {
        return this.myLog(n, resourcePool, l, string, string2, object, -1L);
    }

    public long time(int n, ResourcePool resourcePool, long l, String string, String string2, Object object, long l2) {
        return this.myLog(n, resourcePool, l, string, string2, object, l2);
    }

    protected long myLog(int n, ResourcePool resourcePool, long l, String string, String string2, Object object, long l2) {
        long l3 = -1L;
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append(this.radjust(resourcePool.getName(), 8));
        if (l > 0L) {
            long l4 = System.currentTimeMillis();
            l3 = l4 - l;
            stringBuffer.append(this.ladjust(l3, 6));
        } else {
            stringBuffer.append(this.ladjust("", 6));
        }
        stringBuffer.append(this.radjust(string2, 8));
        stringBuffer.append(this.radjust(string, 20));
        stringBuffer.append(object == null ? "" : object.toString());
        this.myLog(n, stringBuffer.toString());
        if (l > 0L && l2 > 0L && l3 > l2) {
            this.myLog(2, resourcePool, -1L, this.combine(string, string2), "WARN", object + " -- " + l3 + " ms, exceeding max of " + l2, -1L);
        }
        return l3;
    }

    protected void myLog(int n, String string) {
        Level level = this.logConfig.map(n);
        LOGGER.log(level, string);
    }

    public String describe(GuaranteedAction guaranteedAction) {
        if (guaranteedAction == null || guaranteedAction.isSuccessful()) {
            return "";
        }
        if (guaranteedAction.timedOut()) {
            return "timeout";
        }
        if (guaranteedAction.erroredOut()) {
            return "error: " + guaranteedAction.getThrowable();
        }
        if (guaranteedAction.interrupted()) {
            return "interrupted";
        }
        return "";
    }

    protected String combine(String string, String string2) {
        return string2 == null || string2.length() == 0 ? string : string + " / " + string2;
    }

    protected String ladjust(long l, int n) {
        return this.ladjust("" + l, n);
    }

    protected String radjust(long l, int n) {
        return this.radjust("" + l, n);
    }

    protected String ladjust(String string, int n) {
        String string2;
        String string3 = string2 = string == null || string.length() == 0 ? "-" : string;
        while (string2.length() < n) {
            string2 = " " + string2;
        }
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2 + " ";
    }

    protected String radjust(String string, int n) {
        String string2;
        String string3 = string2 = string == null || string.length() == 0 ? "-" : string;
        while (string2.length() < n) {
            string2 = string2 + " ";
        }
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2 + " ";
    }
}

